// Objekte der Klasse RechteckGS sind Rechtecke mit einem Seitenverhältnis nach dem goldenen Schnitt.
package de.bebagoe.figuren;
import java.lang.Math;

public final class RechteckGS extends Rechteck {
    protected Orientierung sl;
	private static double phi = (1 + Math.sqrt(5.0))/2.0;

	public RechteckGS(double x, double y, double b, Orientierung orient) {
        sl = orient;
        super(x, y, b, berechneHoehe(b, orient));
	}
	
	public RechteckGS() {
        sl = Orientierung.LIEGEND;
        super(100.0, berechneHoehe(100, Orientierung.LIEGEND));
    }

    private static double berechneHoehe(double breite, Orientierung orient) {
        if (orient == Orientierung.STEHEND)
            return breite * phi;
        else
            return breite / phi;
    }

	public Orientierung getOrientierung() {
		return sl;
	}
}
